import vs

# Created 240416
# Get shape description for an extrusion plugin ie Extrude Path Planar
# Shape type determines the description content

objH = vs.WSScript_GetObject()

partrec = 'ExtrudePartData'

shapedef = vs.GetRField(objH,partrec,'partname')
notes = vs.GetRField(objH ,partrec,'partnotes')
# notes format [<options>]

if (shapedef  == ''):
	umark = vs.GetPrefString(154)
	dimprec = str(vs.GetPrefLongInt(169))

	btest,val1  = vs.ValidNumStr(vs.GetRField(objH ,partrec,'val1'))
	btest,val2  = vs.ValidNumStr(vs.GetRField(objH ,partrec,'val2'))
	btest,thick = vs.ValidNumStr(vs.GetRField(objH ,partrec,'thickness'))
	
	shapetype = vs.GetRField(objH ,partrec,'parttype')

	if (shapetype == 'Rectangle'):
		if (thick > 0):
			tempstr = "Rect %0."+dimprec+"f x %0."+dimprec+"f x %0."+dimprec+"f %s thick %s"
			shapedef = tempstr % (val1,val2,thick,umark,notes)
		else:
			tempstr = "Rect %0."+dimprec+"f x %0."+dimprec+"f %s %s"
			shapedef = tempstr % (val1,val2,umark,notes)

	elif (shapetype == 'Circle'):
		if (thick > 0):
			tempstr = "Circ diam %0."+dimprec+"f x %0."+dimprec+"f x %0."+dimprec+"f %s thick %s"
			shapedef = tempstr % (val1,val2,thick,umark,notes)
		else:
			tempstr = "Circ diam %0."+dimprec+"f x %0."+dimprec+"f %s %s"
			shapedef = tempstr % (val1,val2,umark,notes)

	elif (shapetype == 'Arc'):
		startangle = float(vs.GetRField(objH ,partrec,'startangle'))
		endangle   = float(vs.GetRField(objH ,partrec,'endangle'))
		arcangle = endangle-startangle
		if (thick > 0):
			tempstr = "Arc diam %0."+dimprec+"f x %0."+dimprec+"f x %0."+dimprec+"f %s thick x %0.1f deg %s"
			shapedef = tempstr % (val1,val2,thick,umark,arcangle,notes)
		else:
			tempstr = "Arc diam %0."+dimprec+"f x %0."+dimprec+"f %s x %0.1f deg %s"
			shapedef = tempstr % (val1,val2,umark,arcangle,notes)

	elif (shapetype == 'Polygon'):
		polysides = vs.GetRField(objH ,partrec,'polysides')
		if (thick > 0):
			tempstr = "Poly diam %0."+dimprec+"f x %0."+dimprec+"f %s thick x %s sides %s"
			shapedef = tempstr % (val1,thick,umark,polysides,notes)
		else:
			tempstr = "Poly diam %0."+dimprec+"f %s x %s sides %s"
			shapedef = tempstr % (val1,umark,polysides,notes)
	elif (shapetype == 'Shape Multi'):
		shapedef = shapedef + notes

elif (notes != ''):
	shapedef = shapedef + ' ' + notes

vs.WSScript_SetResStr(shapedef)